(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13337,        407]*)
(*NotebookOutlinePosition[     14181,        434]*)
(*  CellTagsIndexPosition[     14137,        430]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 1.6  .1 . \[IndentingNewLine]using\ 3 - 
        point\ trapezoidal\ rule\ *) \[IndentingNewLine]\(k[x_, \ s_] := \ 
        If[x \[LessEqual] \ s, \ x\ \((2 - s)\)/2, \ 
          s\ \((2 - x)\)/2];\)\), "\[IndentingNewLine]", 
    \(\(x = {0, \ 1/2, \ 1};\)\), "\n", 
    \(\(s = {0, \ 1/2, \ 1};\)\), "\n", 
    \(matk = Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 3}, {j, 3}]\)}], "Input"],

Cell[BoxData[
    \({{0, 0, 0}, {0, 3\/8, 1\/4}, {0, 1\/4, 1\/2}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(d = {{1/4, 0, 0}, {0, 1/2, \ 0}, \ {0, 0, 
            1/4}};\)\), "\[IndentingNewLine]", 
    \(a = matk\  . d\)}], "Input"],

Cell[BoxData[
    \({{0, 0, 0}, {0, 3\/16, 1\/16}, {0, 1\/8, 1\/8}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(c = \[Mu]\ {{1, 0, 0}, \ {0, 1, 0}, \ {0, 0, 
              1}};\)\), "\[IndentingNewLine]", 
    \(b = a - c\)}], "Input"],

Cell[BoxData[
    \({{\(-\[Mu]\), 0, 0}, {0, 3\/16 - \[Mu], 1\/16}, {0, 1\/8, 
        1\/8 - \[Mu]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[b] \[Equal] \ 0, \ \[Mu]]\)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0}, {\[Mu] \[Rule] 1\/16}, {\[Mu] \[Rule] 
          1\/4}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ using\ 3 - point\ trapezoidal\ rule, \ 
      but\ take\ x0\ and\ s0\ different, \ 
      say\ x0 = \(1/10\ and\ s0 = 0\)\ *) \[IndentingNewLine]\(k[x_, \ 
          s_] := \ If[x \[LessEqual] \ s, \ x\ \((2 - s)\)/2, \ 
          s\ \((2 - x)\)/2];\)\), "\[IndentingNewLine]", 
    \(\(x = {1/10, \ 1/2, \ 1};\)\), "\n", 
    \(\(s = {0, \ 1/2, \ 1};\)\), "\n", 
    \(matk = Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 3}, {j, 3}]\)}], "Input"],

Cell[BoxData[
    \({{0, 3\/40, 1\/20}, {0, 3\/8, 1\/4}, {0, 1\/4, 1\/2}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(d = {{1/4, 0, 0}, {0, 1/2, \ 0}, \ {0, 0, 
            1/4}};\)\), "\[IndentingNewLine]", 
    \(a = matk\  . d\)}], "Input"],

Cell[BoxData[
    \({{0, 3\/80, 1\/80}, {0, 3\/16, 1\/16}, {0, 1\/8, 1\/8}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(c = \[Mu]\ {{1, 0, 0}, \ {0, 1, 0}, \ {0, 0, 
              1}};\)\), "\[IndentingNewLine]", 
    \(b = a - c\)}], "Input"],

Cell[BoxData[
    \({{\(-\[Mu]\), 3\/80, 1\/80}, {0, 3\/16 - \[Mu], 1\/16}, {0, 1\/8, 
        1\/8 - \[Mu]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[b] \[Equal] \ 0, \ \[Mu]]\)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0}, {\[Mu] \[Rule] 1\/16}, {\[Mu] \[Rule] 
          1\/4}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ using\ 3 - point\ trapezoidal\ rule, \ 
      but\ take\ x0\ and\ s0\ nonzero\ and\ different, \ 
      say\ x0 = \(1/100\ and\ s0 = 0\)\ *) \[IndentingNewLine]\(k[x_, \ 
          s_] := \ If[x \[LessEqual] \ s, \ x\ \((2 - s)\)/2, \ 
          s\ \((2 - x)\)/2];\)\), "\[IndentingNewLine]", 
    \(\(x = {1/100, \ 1/2, \ 1};\)\), "\n", 
    \(\(s = {0, \ 1/2, \ 1};\)\), "\n", 
    \(matk = Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 3}, {j, 3}]\)}], "Input"],

Cell[BoxData[
    \({{0, 3\/400, 1\/200}, {0, 3\/8, 1\/4}, {0, 1\/4, 1\/2}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(d = {{1/4, 0, 0}, {0, 1/2, \ 0}, \ {0, 0, 
            1/4}};\)\), "\[IndentingNewLine]", 
    \(a = matk\  . d\)}], "Input"],

Cell[BoxData[
    \({{0, 3\/800, 1\/800}, {0, 3\/16, 1\/16}, {0, 1\/8, 1\/8}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(c = \[Mu]\ {{1, 0, 0}, \ {0, 1, 0}, \ {0, 0, 
              1}};\)\), "\[IndentingNewLine]", 
    \(b = a - c\)}], "Input"],

Cell[BoxData[
    \({{\(-\[Mu]\), 3\/800, 1\/800}, {0, 3\/16 - \[Mu], 1\/16}, {0, 1\/8, 
        1\/8 - \[Mu]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[b]\  \[Equal] \ 0, \ \[Mu]] // N\)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0.`}, {\[Mu] \[Rule] 0.0625`}, {\[Mu] \[Rule] 
          0.25`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ using\ 4 - 
        point\ trapezoidal\ rule\ *) \[IndentingNewLine]\(k[x_, \ s_] := \ 
        If[x \[LessEqual] \ s, \ x\ \((2 - s)\)/2, \ 
          s\ \((2 - x)\)/2];\)\), "\[IndentingNewLine]", 
    \(\(x = {0, \ 1/3, 2/3, \ 1};\)\), "\n", 
    \(\(s = {0, \ 1/3, 2/3, \ 1};\)\), "\n", 
    \(matk = Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 4}, {j, 4}]\)}], "Input"],

Cell[BoxData[
    \({{0, 0, 0, 0}, {0, 5\/18, 2\/9, 1\/6}, {0, 2\/9, 4\/9, 1\/3}, {0, 1\/6, 
        1\/3, 1\/2}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(d = {{1/12, 0, 0, 0}, {0, 1/6, \ 0, 0}, \ {0, 0, 1/6, 0}, \ {0, 0, 0, 
            1/12}};\)\), "\[IndentingNewLine]", 
    \(a = matk\  . d\)}], "Input"],

Cell[BoxData[
    \({{0, 0, 0, 0}, {0, 5\/108, 1\/27, 1\/72}, {0, 1\/27, 2\/27, 1\/36}, {0, 
        1\/36, 1\/18, 1\/24}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(c = \[Mu]\ {{1, 0, 0, 0}, \ {0, 1, 0, \ 0}, \ {0, 0, 1, \ 0}, \ {0, 
              0, 0, 1}};\)\), "\[IndentingNewLine]", 
    \(b = a - c\)}], "Input"],

Cell[BoxData[
    \({{\(-\[Mu]\), 0, 0, 0}, {0, 5\/108 - \[Mu], 1\/27, 1\/72}, {0, 1\/27, 
        2\/27 - \[Mu], 1\/36}, {0, 1\/36, 1\/18, 1\/24 - \[Mu]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[b] \[Equal] 0, \ \[Mu]]\)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0}, {\[Mu] \[Rule] 1\/72}, {\[Mu] \[Rule] 
          1\/54\ \((4 - \@7)\)}, {\[Mu] \[Rule] 
          1\/54\ \((4 + \@7)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0.`}, {\[Mu] \[Rule] 
          0.013888888888888888`}, {\[Mu] \[Rule] 
          0.0250786794247298`}, {\[Mu] \[Rule] 
          0.12306946872341834`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ using\ 4 - point\ trapezoidal\ rule, \ 
      both\ x0\ and\ s0\ different, \ say\ x0 = 1/10, \ 
      s0 = 0\ *) \[IndentingNewLine]\(k[x_, \ s_] := \ 
        If[x \[LessEqual] \ s, \ x\ \((2 - s)\)/2, \ 
          s\ \((2 - x)\)/2];\)\), "\[IndentingNewLine]", 
    \(\(x = {1/10, \ 1/3, 2/3, \ 1};\)\), "\n", 
    \(\(s = {0, \ 1/3, 2/3, \ 1};\)\), "\n", 
    \(\(matk = 
        Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 4}, {j, 
            4}];\)\), "\[IndentingNewLine]", 
    \(\(d = {{1/12, 0, 0, 0}, {0, 1/6, \ 0, 0}, \ {0, 0, 1/6, 0}, \ {0, 0, 0, 
            1/12}};\)\), "\[IndentingNewLine]", 
    \(\(a = matk\  . d;\)\), "\[IndentingNewLine]", 
    \(\(c = \[Mu]\ {{1, 0, 0, 0}, \ {0, 1, 0, \ 0}, \ {0, 0, 1, \ 0}, \ {0, 
              0, 0, 1}};\)\), "\[IndentingNewLine]", 
    \(\(b = a - c;\)\), "\[IndentingNewLine]", 
    \(Solve[Det[b] \[Equal] 0, \ \[Mu]] // N\)}], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0.`}, {\[Mu] \[Rule] 
          0.013888888888888888`}, {\[Mu] \[Rule] 
          0.0250786794247298`}, {\[Mu] \[Rule] 
          0.12306946872341834`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ClearAll;\)\[IndentingNewLine] (*\ 
      using\ 4 - point\ trapezoidal\ rule, \ 
      both\ x0\ and\ s0\ different\ and\ nonzero, \ say\ x0 = 1/100, \ 
      s0 = 1/200\ *) \), "\[IndentingNewLine]", 
    \(\(k[x_, \ s_] := \ 
        If[x \[LessEqual] \ s, \ x\ \((2 - s)\)/2, \ 
          s\ \((2 - x)\)/2];\)\), "\[IndentingNewLine]", 
    \(\(x = {1/100, \ 1/3, 2/3, \ 1};\)\), "\n", 
    \(\(s = {0, \ 1/3, 2/3, \ 1};\)\), "\n", 
    \(\(matk = 
        Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 4}, {j, 
            4}];\)\), "\[IndentingNewLine]", 
    \(\(d = {{1/12, 0, 0, 0}, {0, 1/6, \ 0, 0}, \ {0, 0, 1/6, 0}, \ {0, 0, 0, 
            1/12}};\)\), "\[IndentingNewLine]", 
    \(\(a = matk\  . d;\)\), "\[IndentingNewLine]", 
    \(\(c = \[Mu]\ {{1, 0, 0, 0}, \ {0, 1, 0, \ 0}, \ {0, 0, 1, \ 0}, \ {0, 
              0, 0, 1}};\)\), "\[IndentingNewLine]", 
    \(\(b = a - c;\)\), "\[IndentingNewLine]", 
    \(Solve[Det[b] \[Equal] 0, \ \[Mu]] // N\)}], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0.`}, {\[Mu] \[Rule] 
          0.013888888888888888`}, {\[Mu] \[Rule] 
          0.0250786794247298`}, {\[Mu] \[Rule] 
          0.12306946872341834`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ClearAll;\)\[IndentingNewLine] (*\ using\ Simpson' s\ 3/8\ rule, \ 
      both\ x0\ and\ s0\ same, \ say\ x0 = 0, \ 
      s0 = 0\ *) \), "\[IndentingNewLine]", 
    \(\(k[x_, \ s_] := \ 
        If[x \[LessEqual] \ s, \ x\ \((2 - s)\)/2, \ 
          s\ \((2 - x)\)/2];\)\), "\[IndentingNewLine]", 
    \(\(x = {0, \ 1/3, 2/3, \ 1};\)\), "\n", 
    \(\(s = {0, \ 1/3, 2/3, \ 1};\)\), "\n", 
    \(\(matk = 
        Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 4}, {j, 
            4}];\)\), "\[IndentingNewLine]", 
    \(\(d = {{1/8, 0, 0, 0}, {0, 3/8, \ 0, 0}, \ {0, 0, 3/8, 0}, \ {0, 0, 0, 
            1/8}};\)\), "\[IndentingNewLine]", 
    \(\(a = matk\  . d;\)\), "\[IndentingNewLine]", 
    \(\(c = \[Mu]\ {{1, 0, 0, 0}, \ {0, 1, 0, \ 0}, \ {0, 0, 1, \ 0}, \ {0, 
              0, 0, 1}};\)\), "\[IndentingNewLine]", 
    \(\(b = a - c;\)\), "\[IndentingNewLine]", 
    \(Solve[Det[b] \[Equal] 0, \ \[Mu]] // N\)}], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 
          0.`}, {\[Mu] \[Rule] \(\(0.2572741324607931`\)\(\[InvisibleSpace]\)\
\) - 3.469446951953614`*^-18\ \[ImaginaryI]}, {\[Mu] \[Rule] \
\(\(0.05148255907565536`\)\(\[InvisibleSpace]\)\) + 
            4.163336342344337`*^-17\ \[ImaginaryI]}, {\[Mu] \[Rule] \
\(\(0.024576641796884867`\)\(\[InvisibleSpace]\)\) - 
            4.163336342344337`*^-17\ \[ImaginaryI]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ClearAll;\)\[IndentingNewLine] (*\ using\ Simpson' s\ 3/8\ rule, \ 
      both\ x0\ and\ s0\ different, \ say\ x0 = 1/10, \ 
      s0 = 0\ *) \), "\[IndentingNewLine]", 
    \(\(k[x_, \ s_] := \ 
        If[x \[LessEqual] \ s, \ x\ \((2 - s)\)/2, \ 
          s\ \((2 - x)\)/2];\)\), "\[IndentingNewLine]", 
    \(\(x = {1/10, \ 1/3, 2/3, \ 1};\)\), "\n", 
    \(\(s = {0, \ 1/3, 2/3, \ 1};\)\), "\n", 
    \(\(matk = 
        Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 4}, {j, 
            4}];\)\), "\[IndentingNewLine]", 
    \(\(d = {{1/8, 0, 0, 0}, {0, 3/8, \ 0, 0}, \ {0, 0, 3/8, 0}, \ {0, 0, 0, 
            1/8}};\)\), "\[IndentingNewLine]", 
    \(\(a = matk\  . d;\)\), "\[IndentingNewLine]", 
    \(\(c = \[Mu]\ {{1, 0, 0, 0}, \ {0, 1, 0, \ 0}, \ {0, 0, 1, \ 0}, \ {0, 
              0, 0, 1}};\)\), "\[IndentingNewLine]", 
    \(\(b = a - c;\)\), "\[IndentingNewLine]", 
    \(Solve[Det[b] \[Equal] 0, \ \[Mu]] // N\)}], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 
          0.`}, {\[Mu] \[Rule] \(\(0.2572741324607931`\)\(\[InvisibleSpace]\)\
\) - 3.469446951953614`*^-18\ \[ImaginaryI]}, {\[Mu] \[Rule] \
\(\(0.05148255907565536`\)\(\[InvisibleSpace]\)\) + 
            4.163336342344337`*^-17\ \[ImaginaryI]}, {\[Mu] \[Rule] \
\(\(0.024576641796884867`\)\(\[InvisibleSpace]\)\) - 
            4.163336342344337`*^-17\ \[ImaginaryI]}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{Automatic, 80}, {Automatic, 23}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 423, 7, 107, "Input"],
Cell[2165, 60, 79, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2281, 66, 148, 3, 43, "Input"],
Cell[2432, 71, 81, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2550, 77, 146, 3, 43, "Input"],
Cell[2699, 82, 115, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2851, 89, 68, 1, 27, "Input"],
Cell[2922, 92, 109, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3068, 99, 41, 1, 27, "Input"],
Cell[3112, 102, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3191, 108, 467, 8, 123, "Input"],
Cell[3661, 118, 87, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3785, 124, 148, 3, 43, "Input"],
Cell[3936, 129, 89, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4062, 135, 146, 3, 43, "Input"],
Cell[4211, 140, 123, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4371, 147, 68, 1, 27, "Input"],
Cell[4442, 150, 109, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4588, 157, 41, 1, 27, "Input"],
Cell[4632, 160, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4711, 166, 483, 8, 123, "Input"],
Cell[5197, 176, 89, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5323, 182, 148, 3, 43, "Input"],
Cell[5474, 187, 91, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5602, 193, 146, 3, 43, "Input"],
Cell[5751, 198, 125, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5913, 205, 75, 1, 27, "Input"],
Cell[5991, 208, 114, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6142, 215, 41, 1, 27, "Input"],
Cell[6186, 218, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6265, 224, 395, 7, 91, "Input"],
Cell[6663, 233, 127, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6827, 240, 177, 3, 59, "Input"],
Cell[7007, 245, 136, 2, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7180, 252, 175, 3, 59, "Input"],
Cell[7358, 257, 169, 2, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7564, 264, 66, 1, 27, "Input"],
Cell[7633, 267, 174, 3, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7844, 275, 37, 1, 27, "Input"],
Cell[7884, 278, 202, 4, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8123, 287, 922, 17, 219, "Input"],
Cell[9048, 306, 202, 4, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9287, 315, 996, 19, 251, "Input"],
Cell[10286, 336, 202, 4, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10525, 345, 949, 18, 235, "Input"],
Cell[11477, 365, 422, 7, 62, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11936, 377, 960, 18, 235, "Input"],
Cell[12899, 397, 422, 7, 62, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

